F_fix_upgrade()
{
    F_debug_log "Nothing to fix (openva rpm)" 
}

F_fix_upgrade_script()
{
    F_debug_log "Nothing to fix (openva script)" 
}
#Description: 
# Update the upgrade tool
#
#Arguments: 
# None
#
#Returns:
# 0 if successful, others if failed.
F_self_update()
{
    new_update_tool=`ls -l $UNPACK_DIR/packages/openva-update-tools*.rpm | grep -v "openva-update-tools-debuginfo" | awk '{print $9}'`

    if [ "$new_update_tool" = "" ] || [ ! -e $new_update_tool ]; then
        F_debug_log "Don't need to upgrade openva-update-tools."
        # a workaround for upgrade issue
        F_fix_upgrade
        #return 0
    else
        local_version=`rpm -q openva-update-tools --qf '%{version}-%{release}'`
        new_version=`rpm -q -p $new_update_tool --qf '%{version}-%{release}'`
        if [ "$local_version" = "$new_version" ]; then
            F_debug_log "Don't need to upgrade openva-update-tools."
            # a workaround for upgrade issue
            F_fix_upgrade
        else
            rpm -Uvh $new_update_tool > /dev/null 2>&1
            ret=$?
            if [ $ret -ne 0 ]; then
                F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Upgrade openva-upgrade-tools failed."
                return $ret
            else
                F_debug_log "Upgrade openva-upgrade-tools succeed."
                # a workaround for upgrade issue
                F_fix_upgrade
            fi
            #return $ret
            
        fi
    fi

    #add for update apply_update
    new_openva_script="$UNPACK_DIR/binaries/openva"
    F_debug_log "Openva script folder: $new_openva_script"

    if [ ! -e $new_openva_script ]; then
        F_debug_log "Don't need to upgrade openva-update-tools scripts."
        F_fix_upgrade_script
    else
        F_debug_log "Find openva scripts. Upgrade openva-update-tools scripts."
        original_openva_path="/usr/local/openva-update-tools"
        for f in $new_openva_script/*; do
            test -f "$f" || continue
            f_basename=`basename $f`
            F_debug_log "Copy $f to openva folder: $f_basename"
            cp -a -f $f $original_openva_path/$f_basename
            ret=$?
            if [ $ret -ne 0 ]; then
                F_error_log "$FUNCNAME" "`expr $LINENO - 1`" "Upgrade openva-upgrade-tools script $f failed."
                return $ret
            fi
            # PIX-4232, the user and gruop need to be switch to root
            chown root:root $original_openva_path/$f_basename
        done
    fi

    return 0
}
. /usr/local/openva-update-tools/common
